Contoh Data Statis (Siap Pakai)
Semua data untuk situs statis diletakkan di folder `public/gg/data` dalam bentuk berkas JavaScript global (menggunakan `window.<NAMA>`). Contoh berikut bisa langsung disalin ke berkas-berkas data.

quotes.js
```
window.QUOTES = [
  "GG itu kayak marshmallow—lembut dan selalu bikin happy! 🍡",
  "Senyumnya GG bisa bikin dunia lebih cerah! ☀️",
  "Cinta itu seperti GG: manis, lucu, dan bikin tersenyum! 😊",
  "Setiap hari bersama GG adalah hadiah! 🎁",
  "Keajaiban cinta ada di setiap senyum GG 💫",
  "Waktu bersama GG selalu berwarna dan indah 🌈"
];
```

gallery.js
```
window.GALLERY = [
  { file: "images/sample-1.jpg", title: "Romantic Vibes", caption: "Momen manis berdua", tags: ["romantic", "sweet"] },
  { file: "images/sample-2.jpg", title: "Cute Moments", caption: "Senyum GG bikin hari cerah", tags: ["cute", "smile"] },
  { file: "images/sample-3.jpg", title: "Daily Smiles", caption: "Tawa kecil yang berarti", tags: ["daily"] },
  { file: "images/sample-4.jpg", title: "Sweet Adventures", caption: "Petualangan berdua", tags: ["adventure", "sweet"] },
  { file: "images/sample-5.jpg", title: "Heartwarming", caption: "Pelukan hangat", tags: ["warm"] },
  { file: "images/sample-6.jpg", title: "Magical Moment", caption: "Detik penuh keajaiban", tags: ["magic"] }
];
```

map.js (opsional)
```
window.MAP_POINTS = [
  { name: "Taman Kota", lat: -6.200, lng: 106.816, note: "Tempat jalan bareng GG" },
  { name: "Cafe Favorit", lat: -6.210, lng: 106.825, note: "Latte manis + senyum GG" }
];
```

journal.js (opsional)
```
window.JOURNAL = [
  { date: "2025-02-14", mood: "happy", text: "Valentine yang manis bersama GG" },
  { date: "2025-03-01", mood: "calm", text: "Coffee date dan obrolan hangat" }
];
```

achievements.js (opsional)
```
window.ACHIEVEMENTS = [
  { title: "Cute Moments Badge", earnedAt: "2025-02-14" },
  { title: "Daily Smiles", earnedAt: "2025-03-01" }
];
```

reminders.js (opsional)
```
window.REMINDERS = [
  { date: "2025-02-14", title: "Anniversary" },
  { date: "2025-07-10", title: "Birthday GG" }
];
```

Struktur Folder Disarankan
```
public/gg/
  index.html
  gallery.html
  css/styles.css
  js/app.js
  data/
    quotes.js
    gallery.js
    map.js
    journal.js
    achievements.js
    reminders.js
  images/
    (taruh semua foto di sini)
```

Cara Menambahkan Foto
- Letakkan file gambar (mis. `gg-anniversary.jpg`) di `public/gg/images`.
- Tambahkan objek baru pada `public/gg/data/gallery.js`:

```
window.GALLERY.push({
  file: "images/gg-anniversary.jpg",
  title: "Anniversary",
  caption: "Momen manis bersama GG",
  tags: ["sweet", "anniversary"]
});
```

Catatan
- Semua data bersifat statis dan dibaca langsung di browser.
- Tidak ada upload lewat web (cukup tambahkan file dan edit data). 
- Pastikan nama file di `file:` sesuai dengan foto yang Anda taruh.
