# Rencana Pengembangan Bertahap — Enchanted Love Portal (Statis)

Tujuan: Menyelesaikan aplikasi statis yang ringan, rapi, dan mudah dipelihara. Semua konten dikelola lewat berkas data di `public/gg/data` dan gambar di `public/gg/images`.

## Ringkasan Arsitektur
- HTML/CSS/JS statis di `public/gg/` (tanpa backend/database).
- Data global: `public/gg/data/*.js` (mis. `quotes.js`, `gallery.js`).
- Gambar: `public/gg/images`.
- Dokumen referensi: `docs/rancangan_mentah.md`, `docs/contoh_data.md`.

## Tahap 1 — MVP (Home + Gallery + Lovemeter)
Durasi: 1–2 hari
- [x] Finalisasi `index.html` (greeting, random quotes, lovemeter statis, navigasi).
- [x] Finalisasi `gallery.html` (grid bergaya Pinterest, hover 3D ringan).
- [x] Verifikasi `public/gg/css/styles.css` (tema pastel, animasi halus).
- [x] Verifikasi `public/gg/js/app.js` (inisialisasi halaman + render data).
- [x] Isi `public/gg/data/quotes.js` sesuai preferensi (isi default tersedia, bisa dipersonalisasi).
- [x] Tambahkan foto di `public/gg/images` dan entri di `public/gg/data/gallery.js` (sudah ditambahkan 6 placeholder).
Kriteria selesai:
- Home dan Gallery tampil baik secara lokal.
- Minimal 6 foto tampil dengan judul, caption, dan tags. (Terpenuhi dengan placeholder, silakan ganti dengan foto asli.)

## Tahap 2 — Love Map & Achievements (Opsional)
Durasi: 1 hari
- [x] Buat `map.html` sederhana dengan peta pixel-art statis.
- [x] Tambah `public/gg/data/map.js` (`window.MAP_POINTS = [...]`).
- [x] Buat `achievements.html` untuk menampilkan lencana dari `public/gg/data/achievements.js`.
- [x] Perbarui CSS/JS untuk Map & Achievements, serta navigasi di halaman.
 Kriteria selesai:
- [x] Titik peta tampil (nama + catatan).
- [x] Minimal 3 achievement tampil.

## Tahap 3 — Journal & Reminders (Opsional)
Durasi: 1 hari
- [x] Buat `journal.html` untuk menampilkan entri dari `public/gg/data/journal.js`.
- [x] Buat `reminders.html` untuk daftar tanggal penting dari `public/gg/data/reminders.js`.
- [x] Tambahkan navigasi ke halaman-halaman baru.
- [x] Perbarui CSS/JS untuk komponen Journal & Reminders.
Kriteria selesai:
- [x] Minimal 5 entri journal tampil.
- [x] Minimal 5 reminders tampil dengan tanggal yang benar.

## Tahap 4 — Polishing & Performa
Durasi: 0.5–1 hari
- [x] Optimasi gambar (siapkan panduan di `docs/optimasi_gambar.md`).
- [x] Lazy-load gambar di galeri.
- [x] Cek aksesibilitas: `alt` pada gambar, kontras/focus-visible, skip link.
- [x] Rapi-kan gaya dan komponen UI, serta hormati `prefers-reduced-motion`.
Kriteria selesai:
- [x] Galeri tetap responsif dan cepat di perangkat mobile.
- [x] Tidak ada gambar patah/link rusak (dataset placeholder tervalidasi).

## Tahap 5 — Rilis & Deploy
Durasi: 0.5 hari
- [ ] Pengemasan: pastikan `public/gg` lengkap (HTML, CSS, JS, data, images).
- [ ] Opsi deploy: 
  - Hosting statis (Netlify/Vercel/GitHub Pages) — taruh isi `public/gg` sebagai root.
  - Atau tetap di Laragon: akses via `http://127.0.0.1:8000/gg/index.html`.
- [ ] Dokumentasikan cara update konten (foto & data).
Kriteria selesai:
- Situs dapat diakses publik/lokal dengan konten lengkap.

## Manajemen Data
- Quotes: `public/gg/data/quotes.js` → `window.QUOTES = [...]`.
- Gallery: `public/gg/data/gallery.js` → `window.GALLERY = [{ file, title, caption, tags }]`.
- Tambah foto: taruh file di `public/gg/images`, lalu tambahkan objek ke `window.GALLERY`.

## Konvensi Penamaan
- Gambar: gunakan nama deskriptif, huruf kecil, pemisah `-` (contoh: `gg-anniversary.jpg`).
- Tags: huruf kecil konsisten (mis. `sweet`, `anniversary`, `cute`).

## Testing Manual
- Jalankan server lokal: `php -S 127.0.0.1:8000 -t public`.
- Uji halaman: `index.html`, `gallery.html` (dan halaman opsional jika ada).
- Periksa tampilan di mobile (DevTools) dan gambar/tautan.

## Risiko & Mitigasi
- Gambar patah (path salah) → cek `file:` di `gallery.js` dan nama file.
- Performa lambat (gambar besar) → kompres gambar ke JPG/WebP.
- Konflik data global → gunakan nama variabel `window.*` konsisten per file.

## Checklist Rilis
- [ ] Home & Gallery berfungsi dan responsif.
- [ ] Minimal 10 foto dengan metadata rapi.
- [ ] Tidak ada 404 pada asset.
- [ ] Data di `quotes.js` dan `gallery.js` sudah personal untuk GG.

## Tahap 6 — Penyederhanaan Modul & Road of Cuteness + Mini Games
Durasi: 1–2 hari

### A. Penghapusan Modul Lama (Map, Achievements, Journal, Reminders)
- [x] Hapus halaman: `public/gg/map.html`, `public/gg/achievements.html`, `public/gg/journal.html`, `public/gg/reminders.html`.
- [x] Hapus data terkait: `public/gg/data/map.js` (jika ada), `public/gg/data/achievements.js` (jika ada), `public/gg/data/journal.js`, `public/gg/data/reminders.js`.
- [x] Hapus fungsi inisialisasi di `public/gg/js/app.js`: `initMap`, `initAchievements`, `initJournal`, `initReminders`.
- [x] Bersihkan CSS terkait komponen Map/Achievements/Journal/Reminders di `public/gg/css/styles.css`.
- [x] Perbarui navigasi pada `public/gg/index.html` dan `public/gg/gallery.html` untuk hanya menampilkan: Home, Gallery, Road.
Kriteria selesai:
- [x] Tidak ada tautan rusak/404 akibat halaman yang dihapus.
- [x] Navbar konsisten di semua halaman dan tidak merujuk modul yang dihapus.

### B. Road of Cuteness (Slideshow Cute Satu-per-Satu)
- [x] Buat halaman baru `public/gg/road.html` yang menampilkan foto dari `window.GALLERY` satu per satu.
- [x] Kontrol slideshow: tombol `Prev/Next`, `Play/Pause`, indikator progres (bar atau steps).
- [x] Tampilkan `title`/`caption` dari setiap item `GALLERY` sebagai keterangan foto.
- [x] Tema unik dan cute (pilih minimal 3):
  - Pastel Love — latar gradient pastel + hearts lembut.
  - Starry Sparkle — bintang berkilau + glow tipis.
  - Polaroid Pink — frame polaroid + sticker lucu.
- [x] Randomizer tema per foto atau per sesi (opsional, dengan tombol pilih tema manual). (Saat ini: pemilih tema manual tersedia)
- [x] Hormati `prefers-reduced-motion` (animasi ringan, durasi singkat), gunakan `loading="lazy"`/`decoding="async"` pada gambar.
Kriteria selesai:
- [x] Semua foto di `GALLERY` dapat ditampilkan dan dijelajahi dalam satu putaran.
- [x] Mobile-first, navigasi mudah (opsional: swipe gesture di perangkat sentuh).
- [x] Performa lancar di perangkat mid-range; tidak ada jank berat.

### C. Mini Games (disisipkan di `road.html`)
Game 1 — Pertanyaan Validasi (Tombol "Tidak" lari)
- [x] Tampilkan pertanyaan (contoh: "Apakah kamu sayang aku?") dengan tombol `Ya` dan `Tidak`.
- [x] Tombol `Tidak` bergerak/menjauh saat pointer/keyboard akan memilihnya sehingga tidak bisa diklik.
- [x] Klik `Ya` memicu animasi confetti/hearts dan lanjut ke foto berikut.
- Aksesibilitas:
  - [x] Tombol memakai `:focus-visible`, dapat dioperasikan via keyboard; jika `prefers-reduced-motion`, animasi diganti transisi minimal.

Game 2 — Tangkap Hati
- [x] Hati kecil jatuh perlahan; target: tangkap 5 untuk membuka "bonus photo".

Game 3 — Komplimen Manis
- [x] Input teks yang memvalidasi pesan manis sebelum lanjut (contoh: minimal 10 huruf, tanpa kata negatif).

Kriteria selesai mini games:
- [x] Semua game tidak mengganggu alur slideshow dan dapat dinonaktifkan (toggle "Mini Games aktif").
- [x] Dapat diakses via keyboard; performa baik dan menghormati `prefers-reduced-motion`.

Catatan:
- [ ] Tahap 5 (Rilis & Deploy) dapat dilewati sementara; fokus menyelesaikan Tahap 6 terlebih dahulu.